/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Distributor
**
** DESCRIPTION:	Distributors
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef DISTRIBUTOR_H
#define DISTRIBUTOR_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwImage.h"

/******************************************************************************\
** CLASS ENUMERATIONS
\******************************************************************************/
enum EDistributor
{
	eDistributor_None = -1,

	eDistributor_LDW = 0,
	eDistributor_PalmGear,
	eDistributor_Handango,
	eDistributor_BFG,
	eDistributor_Generic,
	eDistributor_AOL,
	eDistributor_Real,
	eDistributor_IWin,
	eDistributor_Yahoo,
	eDistributor_Oberon,
	eDistributor_Shockwave,
	eDistributor_MacGamesStore,
	eDistributor_GameHouse,
	eDistributor_GameFiesta,
	eDistributor_PlayFirst,
	eDistributor_ArcadeTown,
	eDistributor_Boonty,
	eDistributor_FreezeTag,
	eDistributor_GameBub,
	eDistributor_Grab,
	eDistributor_SCAnd,
	eDistributor_SkillJam,
	eDistributor_DFG,
	eDistributor_Slingo,
	eDistributor_Zylom,
	eDistributor_SpinTop,

	eDistributor_NumberOf
};

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const EDistributor Distributor_c_eDistributor = eDistributor_LDW;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CDistributor
{
private:

	//class data
	ldwImage*	m_pMenuLogo;
	ldwImage*	m_pLoadingLogo;

	//class methods
	//setup

public:

	CDistributor(void);
	void LoadAssets();
	void ReleaseAssets();

	//process
	void DrawMenuLogo(const int iXCenterPos, const int iYCenterPos);
	void DrawLoadingLogo(const int iXCenterPos, const int iYCenterPos);

	bool HasMenuLogo();
	
	//access
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CDistributor		Distributor;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/

